import 'dart:convert';

import 'package:get/get.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/model/commission/commission_log_response_model.dart' as com;
import 'package:viserpay_agent/data/model/global/response_model/response_model.dart';
import 'package:viserpay_agent/data/repo/commission/commission_log_repo.dart';
import 'package:viserpay_agent/view/components/snack_bar/show_custom_snackbar.dart';

class CommissionLogController extends GetxController {
  CommissionLogRepo commissionLogRepo;
  CommissionLogController({required this.commissionLogRepo});

  bool isLoading = true;
  com.CommissionLogResponseModel model = com.CommissionLogResponseModel();

  List<com.Data> commissionList = [];
  String? nextPageUrl = '';
  String trx = '';
  String currency = '';
  String currencySym = '';
  int page = 0;

  void loadPaginationData() async {
    await loadData();
    update();
  }

  void initialSelectedValue() async {
    currency = commissionLogRepo.apiClient.getCurrencyOrUsername(isCurrency: true);
    currencySym = commissionLogRepo.apiClient.getCurrencyOrUsername(isSymbol: true);
    page = 0;
    commissionList.clear();
    isLoading = true;
    update();
    await loadData();
    isLoading = false;
    update();
  }

  Future<void> loadData() async {
    page = page + 1;
    if (page == 1) {
      commissionList.clear();
    }

    ResponseModel responseModel = await commissionLogRepo.getCommissionLogData(page);
    if (responseModel.statusCode == 200) {
      model = com.CommissionLogResponseModel.fromJson(jsonDecode(responseModel.responseJson));
      nextPageUrl = model.data?.logs?.nextPageUrl;

      if (model.status.toString().toLowerCase() == "success") {
        List<com.Data>? tempList = model.data?.logs?.data;
        if (tempList != null && tempList.isNotEmpty) {
          commissionList.addAll(tempList);
        }
      } else {
        CustomSnackBar.error(errorList: model.message?.error ?? [MyStrings.somethingWentWrong]);
      }
    } else {
      CustomSnackBar.error(errorList: [responseModel.message]);
    }

    isLoading = false;
    update();
  }

  bool hasNext() {
    return nextPageUrl != null && nextPageUrl!.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }
}
